﻿// See https://aka.ms/new-console-template for more information
using System;
using System.Collections;
using System.Net;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;

public class Client
{
    public string prenom { get; set; } // transformation des variables en objet JSON via get et set
    
    
    public string nom { get; set; }
    public string title { get; set; }

    [JsonPropertyName("userId")]
    public int IDclient { get; set; }

    public Client(string prenom, string nom, int IDclient)
    {
        this.prenom = prenom;
        this.nom = nom;
        this.IDclient = IDclient;
    }

}


public class Todo
{
    public int UserId { get; set; }
    public int Id { get; set; }
    public string Title { get; set; }
    public bool Ccompleted { get; set; }
}

public class Dossier
{
    public string IDdossier { get; set; }
    public string typeDemande { get; set; }
    public Client client { get; set; }

    public Dossier(string IDdossier, string typeDemande, Client client)
    {
        this.IDdossier = IDdossier;
        this.typeDemande = typeDemande;
        this.client = client;

    }

}

public class Principale
{
    static void Main()
    {
        Client client1 = new Client("Jean", "Dupont", 1);
        Client client2 = new Client("Hugo", "Dubois", 2);
        Client client3 = new Client("Tintin", "Dupuis", 3);

        ArrayList listeClients = new ArrayList();
        listeClients.Add(client1);
        listeClients.Add(client2);
        listeClients.Add(client3);
        
        Dossier dossier1 = new Dossier("1", "amenagement", client1);
        Dossier dossier2 = new Dossier("2", "construction", client2);

        ArrayList listeDossiers = new ArrayList();
        listeDossiers.Add(dossier1);
        listeDossiers.Add(dossier2);

        /*
        Console.WriteLine("Veuillez fournir votre numero client");
        string numfournisStr = Console.ReadLine();
        int numfournis = 0;
        int.TryParse(numfournisStr, out numfournis);
        foreach (Client i in listeClients)
        {
            if (i.IDclient == numfournis)
            {
                Console.WriteLine("\n" + i.prenom + " " + i.nom);

            }
        }
        */

        var client = new HttpClient();
        client.BaseAddress = new Uri("https://jsonplaceholder.typicode.com/");
        var response = client.GetAsync("todos/1").Result;
        if (response.IsSuccessStatusCode)
        {
            var responseContent = response.Content.ReadAsStringAsync().Result;
            var Client = System.Text.Json.JsonSerializer.Deserialize<Client>(responseContent);
            Console.WriteLine("Get successful!");
            Console.WriteLine("prenom: " + Client.prenom);
            Console.WriteLine("Id: " + Client.IDclient);
            Console.WriteLine("Title: " + Client.title);
        }
        else
        {
            Console.WriteLine("Error: " + response.StatusCode);
        }
        
        

    }

    

}